/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*------------------------- [c]2020 - D. Ottensmeyer ------------------------*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~
 ~ Target:    Arduino NANO with RoboDuck (created by the "Fakultät für Physik
 ~            der Universität Regensburg", Germany, in 2019).
 ~            Link: http://www.physik.uni-regensburg.de/rsl/roboduck.html
 ~ Example:   RoboDuck_Demo_02
 ~ Version:   0.90
 ~ Author(s): D. Ottensmeyer
 ~
 ~ Description:
 ~ In this example we show a second test for the RoboDuck.
 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Defines:
//#define SERVO_CENTER
//#define SERVO_DEFAULT
#define DEMO_RUN

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Includes:
#include <RoboDuck.h>

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Constants:

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Variables:

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

void setup() {
/*
  // Initialize serial:
  Serial.begin(9600); 
  Serial.println("Arduino NANO RoboDuck Test 2!");
  Serial.println("");
  Serial.println("PLEASE ENSURE THAT ROBODUCK CAN MOVE FREELY!!!");
  Serial.println("");
*/

// Assign Arduino Nano ports to the LEDs:
  pinMode(LED_BUILTIN, OUTPUT);     // built-in LED pin
  pinMode(LED_R_GREEN_PIN, OUTPUT); // pin 14 (A0, PC0)
  pinMode(LED_L_RED_PIN, OUTPUT);   // pin 15 (A1, PC1)

// Assign an Arduino Nano port to the Beeper:
  pinMode(BEEPER_PIN, OUTPUT);      // pin 5 (PD5)

#ifdef SERVO_CENTER
  Servo_Init();
  AllServo_Center();
  while(1);
#endif

#ifdef SERVO_DEFAULT 
  Servo_Init();  
  AllServo_Default();
  while(1);
#endif

#ifdef DEMO_RUN 
  Servo_Init();
  AllServo_Default();
  delay(2000);
#endif
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

void loop() {
// Lets dance:
  Dancing1_2();
  delay(500);    
  Dancing3(5,20);
  delay(500);    
  Dancing4();
  delay(500);    
  Dancing5();
  delay(500);    
  Dancing6();
  delay(500);
  Quack();
  while(1);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
