/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*          SSS                                                              */
/*         SSSSS                                                             */
/*    SSSSSS SSSS                                                            */
/*     SSSSSSSSS                                                             */
/*          SSSS                                       ___   ___             */
/*          SSS         -----------------------       /   \ /   \            */
/*         SSSA        | R o b o D u c k _ B T |     (  -  x  +  )           */
/*        SSSSSSN       -----------------------       \___/ \___/            */
/*        SSSSSSSN                                      ARDUINO              */
/*       SSSSSSSSSSSA                                                        */
/*       SSSSSSSSSSSSSSSSSSS                                                 */
/*        SSSSSSSSSSSSSSSSS                                                  */
/*          SSSSSSSSSSS                                                      */
/*              S S                                                          */
/*            SSSSS                                                          */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*------------------------- [c]2020 - D. Ottensmeyer ------------------------*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~
 ~ Target:    Arduino NANO with RoboDuck (created by the "Fakultät für Physik
 ~            der Universität Regensburg", Germany, in 2019).
 ~            Link: http://www.physik.uni-regensburg.de/rsl/roboduck.html
 ~            With Bluetooth module HC-05 or HC-06 connected to RoboDuck
 ~            and with an Android Bluetooth Control app.
 ~ Library:   RoboDuck_BT Header
 ~ Version:   0.90
 ~ Author(s): D. Ottensmeyer
 ~
 ~ Description:
 ~ This is the RoboDuck_BT Library header file.
 ~ You have to include this file, if you want to use the library
 ~ RoboDuck_BT.cpp in your own projects.
 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

#ifndef __ROBODUCK_BT_H__
#define __ROBODUCK_BT_H__

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// RoboDuck additional component:
// - Bluetooth module HC-05 or HC-06

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Includes:
#include <Arduino.h>

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Arduino Nano definitions:
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Arduino Nano <-> RoboDuck Connection Table:
//   Arduino Nano: ATmega328:              RoboDuck:
//   Pin Function  Pin  Functions          Additional Component
//  ------------------------------------------------------------
//    0  D0  RX    PD0  RXD_PCINT16
//    1  D1  TX    PD1  TXD_PCINT17
//    2  D2        PD2  INT0_PCINT18
//    3  D3  PWM   PD3  INT1_OC2B_PCINT19
//    4  D4        PD4  T0_XCK_PCINT20
//    5  D5  PWM   PD5  T1_OC0B_PCINT21
//    6  D6  PWM   PD6  AIN0_OC0A_PCINT22  BT TX
//    7  D7        PD7  AIN1_PCINT23       BT RX
//    8  D8        PB0  ICP1_CLKO_PCINT0
//    9  D9  PWM   PB1  OC1A_PCINT1
//   10  D10 PWM   PB2  SS_OC1B_PCINT2
//   11  D11 PWM   PB3  MOSI_OC2A_PCINT13
//   12  D12       PB4  MISO_PCINT4
//   13  D13       PB5  SCK_PCINT5
//
//    0  A0        PC0  ADC0_PCINT8
//    1  A1        PC1  ADC1_PCINT9
//    2  A2        PC2  ADC2_PCINT10
//    3  A3        PC3  ADC3_PCINT11
//    4  A4  SDA   PC4  ADC4_SDA_PCINT12
//    5  A5  SCL   PC5  ADC5_SCL_PCINT13

// Arduino Nano ATmega 328 portpin names:
#define IO_ARD_D0_RXD_PCINT16        0
#define IO_ARD_D1_TXD_PCINT17        1
#define IO_ARD_D2_INT0_PCINT18       2
#define IO_ARD_D3_INT1_OC2B_PCINT19  3
#define IO_ARD_D4_T0_XCK_PCINT20     4
#define IO_ARD_D5_T1_OC0B_PCINT21    5
#define IO_ARD_D6_AIN0_OC0A_PCINT22  6
#define IO_ARD_D7_AIN1_PCINT23       7
#define IO_ARD_D8_ICP1_CLKO_PCINT0   8
#define IO_ARD_D9_OC1A_PCINT1        9
#define IO_ARD_D10_SS_OC1B_PCINT2    10
#define IO_ARD_D11_MOSI_OC2A_PCINT13 11
#define IO_ARD_D12_MISO_PCINT4       12
#define IO_ARD_D13_SCK_PCINT5        13

#define AD_ARD_A0_ADC0_PCINT8      0
#define AD_ARD_A1_ADC1_PCINT9      1
#define AD_ARD_A2_ADC2_PCINT10     2
#define AD_ARD_A3_ADC3_PCINT11     3
#define AD_ARD_A4_ADC4_SDA_PCINT12 4
#define AD_ARD_A5_ADC5_SCL_PCINT13 5

// Arduino Nano portpin short definitions:
#define IO_ARD_D0_RX   0
#define IO_ARD_D1_TX   1
#define IO_ARD_D2      2
#define IO_ARD_D3_PWM  3
#define IO_ARD_D4      4
#define IO_ARD_D5_PWM  5
#define IO_ARD_D6_PWM  6
#define IO_ARD_D7      7
#define IO_ARD_D8      8
#define IO_ARD_D9_PWM  9
#define IO_ARD_D10_PWM 10
#define IO_ARD_D11_PWM 11
#define IO_ARD_D12     12
#define IO_ARD_D13     13

#define AD_ARD_A0     0
#define AD_ARD_A1     1
#define AD_ARD_A2     2
#define AD_ARD_A3     3
#define AD_ARD_A4_SDA 4
#define AD_ARD_A5_SCL 5

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Bluetooth module HC-05 or HC-06:
#define RX_PIN 6 // Arduino pin 6 (PD6) tied to TX pin.
#define TX_PIN 7 // Arduino pin 7 (PD7) tied to RX pin
                 //  through a voltage divider.

// Functions/Funktionen:
void BT_Begin(uint16_t);
#define BT_Start(__baud__) BT_Begin(__baud__)
uint8_t BT_Available(void);
#define BT_Vorhanden() BT_Available()
uint8_t BT_Read(void);
#define BT_Lese() BT_Read()
void BT_Write(uint8_t);
#define BT_Schreibe(__char__) BT_Write(__char__)
void BT_WriteString(char *);
#define BT_SchreibeZeichen(__str__) BT_WriteString(__str__)
bool BT_Control(char *, uint8_t *);
#define BT_Steuern(__char__, __cnt__) BT_Control(__char__, __cnt__)

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/




/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

#endif

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Additional info
 ~ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Changelog:
 ~
 ~  ---> changes are documented in the file "RoboDuck_BT.cpp"
 ~
 ~ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
