/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*          SSS                                                              */
/*         SSSSS                                                             */
/*    SSSSSS SSSS                                                            */
/*     SSSSSSSSS                                                             */
/*          SSSS                                      ___   ___              */
/*          SSS         -----------------            /   \ /   \             */
/*         SSSA        | R o b o D u c k |          (  -  x  +  )            */
/*        SSSSSSN       -----------------            \___/ \___/             */
/*        SSSSSSSN                                     ARDUINO               */
/*       SSSSSSSSSSSA                                                        */
/*       SSSSSSSSSSSSSSSSSSS                                                 */
/*        SSSSSSSSSSSSSSSSS                                                  */
/*          SSSSSSSSSSS                                                      */
/*              S S                                                          */
/*            SSSSS                                                          */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*------------------------- [c]2020 - D. Ottensmeyer ------------------------*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~
 ~ Target:    Arduino NANO with RoboDuck (created by the "Fakultät für Physik
 ~            der Universität Regensburg", Germany, in 2019).
 ~            Link: go.ur.de/roboduck
 ~ Library:   RoboDuck Header
 ~ Version:   0.90
 ~ Author(s): D. Ottensmeyer
 ~
 ~ Description:
 ~ This is the RoboDuck Library header file.
 ~ You have to include this file, if you want to use the library
 ~ RoboDuck.cpp in your own projects.
 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

#ifndef __ROBODUCK_H__
#define __ROBODUCK_H__

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// RoboDuck standard components:
// - Servos (Micro Servo SG90)
// - Ultrasonic Distance Sensor (HY-SRF05)
// - Beeper (CLW1027)
// - LEDs

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Includes:
#include <Arduino.h>
#include <VarSpeedServo.h>  // include the VarSpeedServo library
#include <Ultrasonic.h>     // include the Ultrasonic library

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Arduino Nano definitions:
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Arduino Nano <-> RoboDuck Connection Table:
//   Arduino Nano: ATmega328:              RoboDuck:
//   Pin Function  Pin  Functions          Standard Component
//  -----------------------------------------------------------
//    0  D0  RX    PD0  RXD_PCINT16
//    1  D1  TX    PD1  TXD_PCINT17
//    2  D2        PD2  INT0_PCINT18
//    3  D3  PWM   PD3  INT1_OC2B_PCINT19  US Echo
//    4  D4        PD4  T0_XCK_PCINT20     US Trigger
//    5  D5  PWM   PD5  T1_OC0B_PCINT21
//    6  D6  PWM   PD6  AIN0_OC0A_PCINT22
//    7  D7        PD7  AIN1_PCINT23
//    8  D8        PB0  ICP1_CLKO_PCINT0   HeadServo
//    9  D9  PWM   PB1  OC1A_PCINT1        RightLegServo
//   10  D10 PWM   PB2  SS_OC1B_PCINT2     RightFootServo
//   11  D11 PWM   PB3  MOSI_OC2A_PCINT13  LeftLegServo
//   12  D12       PB4  MISO_PCINT4        LeftFootServo
//   13  D13       PB5  SCK_PCINT5
//
//    0  A0        PC0  ADC0_PCINT8        GreenLED
//    1  A1        PC1  ADC1_PCINT9        RedLED
//    2  A2        PC2  ADC2_PCINT10       Beeper
//    3  A3        PC3  ADC3_PCINT11
//    4  A4  SDA   PC4  ADC4_SDA_PCINT12
//    5  A5  SCL   PC5  ADC5_SCL_PCINT13

// Arduino Nano ATmega 328 portpin names:
#define IO_ARD_D0_RXD_PCINT16        0
#define IO_ARD_D1_TXD_PCINT17        1
#define IO_ARD_D2_INT0_PCINT18       2
#define IO_ARD_D3_INT1_OC2B_PCINT19  3
#define IO_ARD_D4_T0_XCK_PCINT20     4
#define IO_ARD_D5_T1_OC0B_PCINT21    5
#define IO_ARD_D6_AIN0_OC0A_PCINT22  6
#define IO_ARD_D7_AIN1_PCINT23       7
#define IO_ARD_D8_ICP1_CLKO_PCINT0   8
#define IO_ARD_D9_OC1A_PCINT1        9
#define IO_ARD_D10_SS_OC1B_PCINT2    10
#define IO_ARD_D11_MOSI_OC2A_PCINT13 11
#define IO_ARD_D12_MISO_PCINT4       12
#define IO_ARD_D13_SCK_PCINT5        13

#define AD_ARD_A0_ADC0_PCINT8      0
#define AD_ARD_A1_ADC1_PCINT9      1
#define AD_ARD_A2_ADC2_PCINT10     2
#define AD_ARD_A3_ADC3_PCINT11     3
#define AD_ARD_A4_ADC4_SDA_PCINT12 4
#define AD_ARD_A5_ADC5_SCL_PCINT13 5

// Arduino Nano portpin short definitions:
#define IO_ARD_D0_RX   0
#define IO_ARD_D1_TX   1
#define IO_ARD_D2      2
#define IO_ARD_D3_PWM  3
#define IO_ARD_D4      4
#define IO_ARD_D5_PWM  5
#define IO_ARD_D6_PWM  6
#define IO_ARD_D7      7
#define IO_ARD_D8      8
#define IO_ARD_D9_PWM  9
#define IO_ARD_D10_PWM 10
#define IO_ARD_D11_PWM 11
#define IO_ARD_D12     12
#define IO_ARD_D13     13

#define AD_ARD_A0     0
#define AD_ARD_A1     1
#define AD_ARD_A2     2
#define AD_ARD_A3     3
#define AD_ARD_A4_SDA 4
#define AD_ARD_A5_SCL 5

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Servos (Micro Servo SG90):
#define HEADSERVO_PIN        8
#define RIGHTLEGSERVO_PIN    9
#define RIGHTFOOTSERVO_PIN   10
#define LEFTLEGSERVO_PIN     11
#define LEFTFOOTSERVO_PIN    12

#define KOPFSERVO_PIN        8
#define RECHTESBEINSERVO_PIN 9
#define RECHTERFUSSSERVO_PIN 10
#define LINKESBEINSERVO_PIN  11
#define LINKERFUSSSERVO_PIN  12

#define HEAD         0
#define RIGHT_LEG    1
#define RIGHT_FOOT   2
#define LEFT_LEG     3
#define LEFT_FOOT    4

#define KOPF         0
#define RECHTES_BEIN 1
#define RECHTER_FUSS 2
#define LINKES_BEIN  3
#define LINKER_FUSS  4

#define WAHR   true
#define FALSCH false

// Functions / Funktionen:
void Servo_Init(void);
#define ServoStart() Servo_Init()
void AllServo_Center(void);
#define Mittelstellung() AllServo_Center()
void Servo_Default(int);
#define ServoNormalstellung(__servo) Servo_Default(__servo)
void AllServo_Default(void);
#define Normalstellung() AllServo_Default()
void FeetServo_Default(void);
#define NormalstellungFuesse() FeetServo_Default()
int defPos(int);
#define NormPos(__servo) defPos(__servo)
void Waitwhilemoving(void);
#define WarteBewegungAb() Waitwhilemoving()
bool isServoMoving(int);
#define BewegtSichServo(__servo) isServoMoving(__servo)
void ServoWrite(int, int, int, int);
#define StelleServo(__servo, __pos, __speed, __blocking) \
        ServoWrite(__servo, __pos, __speed, __blocking)
#define MoveHead(__position) ServoWrite(HEAD, __position, 70, 0)
#define BewegeKopf(__position) MoveHead(__position)
#define HeadCenter() ServoWrite(HEAD, 90, 70, 0)
#define KopfMitte() HeadCenter()
#define HeadRight45() ServoWrite(HEAD, 45, 70, 0)
#define KopfRechts45() HeadRight45()
#define HeadLeft45() ServoWrite(HEAD, 135, 70, 0)
#define KopfLinks45() HeadLeft45()
#define MoveRightLeg(__position) ServoWrite(RIGHT_LEG, __position, 50, 0)
#define BewegeRechtesBein(__position) MoveRightLeg(__position)
#define MoveRightFoot(__position) ServoWrite(RIGHT_FOOT, __position, 50, 0)
#define BewegeRechtenFuss(__position) MoveRightFoot(__position)
#define MoveLeftLeg(__position) ServoWrite(LEFT_LEG, __position, 50, 0)
#define BewegeLinkesBein(__position) MoveLeftLeg(__position)
#define MoveLeftFoot(__position) ServoWrite(LEFT_FOOT, __position, 50, 0)
#define BewegeLinkenFuss(__position) MoveLeftFoot(__position)
void ServoStop(int);
#define StoppeServo(__servo) ServoStop(__servo)
void ServoSequence(int, servoSequencePoint *, uint8_t, bool, uint8_t);
#define ServoSequenz(__servo, __posarray, __sequpos, __loop, __startpos) \
        ServoSequence(__servo, __posarray, __sequpos, __loop, __startpos)
void SequenceStop(int);
#define StoppeSequenz(__servo) SequenceStop(__servo)
void Walkahead(int, int);
#define GeheVorwaerts(__steps, __speed) Walkahead(__steps, __speed)
void Walkback(int, int);
#define GeheZurueck(__steps, __speed) Walkback(__steps, __speed)
void Turnleft(int);
#define DreheLinks(__steps) Turnleft(__steps)
void Turnright(int);
#define DreheRechts(__steps) Turnright(__steps)
void Slide_2_Left(int);
#define GleiteNachLinks(__times) Slide_2_Left(__times)
void Slide_2_Right(int);
#define GleiteNachRechts(__times) Slide_2_Right(__times)
void Left_Foot_Support(void);
#define TanzLinkesBein() Left_Foot_Support()
void Right_Foot_Support(void);
#define TanzRechtesBein() Right_Foot_Support()
void Dancing1_2(void);
#define Tanz1_2() Dancing1_2()
void Dancing3(int, int);
#define Tanz3(__times, __vel) Dancing3(__times, __vel)
void Dancing4(void);
#define Tanz4() Dancing4()
void Dancing5(void);
#define Tanz5() Dancing5()
void Dancing6(void);
#define Tanz6() Dancing6()

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Ultrasonic Distance Sensor (HY-SRF05):
#define TRIGGER_PIN  4   // Arduino pin 4 (PD4) tied to Trigger pin.
#define ECHO_PIN     3   // Arduino pin 3 (PD3) tied to Echo pin.
#define MAX_DISTANCE 200 // Maximum distance we want to ping for (in cm).
                         //  Maximum sensor distance is about 450 cm.
                         //  If you want to use a MAX_DISTANCE, that is
                         //  higher than 200 cm (NOT TO BE RECOMMENDED FOR
                         //  ROBODUCK!), you MUST increase the timeout
                         //  value [us] of the Ultrasonic function!
                         //  The Ultrasonic function can be found in
                         //  RoboDuck.cpp.
#define MAX_ENTFERNUNG MAX_DISTANCE

// Functions:
int Distance_cm(void);
#define Entfernung_cm() Distance_cm()
bool TooClose(void);
#define ZuNah() TooClose()
void Walkahead_US(int, int);
#define GeheVorwaerts_US(__steps, __speed) Walkahead_US(__steps, __speed)

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Beeper (CLW1027):
#define BEEPER_PIN 5   // Arduino pin 5 (PD5) tied to the beeper.

// Pitch values [Hz] for the Arduino tone() function:
#define NOTE_B0  31
#define NOTE_C1  33
#define NOTE_CS1 35
#define NOTE_D1  37
#define NOTE_DS1 39
#define NOTE_E1  41
#define NOTE_F1  44
#define NOTE_FS1 46
#define NOTE_G1  49
#define NOTE_GS1 52
#define NOTE_A1  55
#define NOTE_AS1 58
#define NOTE_B1  62
#define NOTE_C2  65
#define NOTE_CS2 69
#define NOTE_D2  73
#define NOTE_DS2 78
#define NOTE_E2  82
#define NOTE_F2  87
#define NOTE_FS2 93
#define NOTE_G2  98
#define NOTE_GS2 104
#define NOTE_A2  110
#define NOTE_AS2 117
#define NOTE_B2  123
#define NOTE_C3  131
#define NOTE_CS3 139
#define NOTE_D3  147
#define NOTE_DS3 156
#define NOTE_E3  165
#define NOTE_F3  175
#define NOTE_FS3 185
#define NOTE_G3  196
#define NOTE_GS3 208
#define NOTE_A3  220
#define NOTE_AS3 233
#define NOTE_B3  247
#define NOTE_C4  262
#define NOTE_CS4 277
#define NOTE_D4  294
#define NOTE_DS4 311
#define NOTE_E4  330
#define NOTE_F4  349
#define NOTE_FS4 370
#define NOTE_G4  392
#define NOTE_GS4 415
#define NOTE_A4  440
#define NOTE_AS4 466
#define NOTE_B4  494
#define NOTE_C5  523
#define NOTE_CS5 554
#define NOTE_D5  587
#define NOTE_DS5 622
#define NOTE_E5  659
#define NOTE_F5  698
#define NOTE_FS5 740
#define NOTE_G5  784
#define NOTE_GS5 831
#define NOTE_A5  880
#define NOTE_AS5 932
#define NOTE_B5  988
#define NOTE_C6  1047
#define NOTE_CS6 1109
#define NOTE_D6  1175
#define NOTE_DS6 1245
#define NOTE_E6  1319
#define NOTE_F6  1397
#define NOTE_FS6 1480
#define NOTE_G6  1568
#define NOTE_GS6 1661
#define NOTE_A6  1760
#define NOTE_AS6 1865
#define NOTE_B6  1976
#define NOTE_C7  2093
#define NOTE_CS7 2217
#define NOTE_D7  2349
#define NOTE_DS7 2489
#define NOTE_E7  2637
#define NOTE_F7  2794
#define NOTE_FS7 2960
#define NOTE_G7  3136
#define NOTE_GS7 3322
#define NOTE_A7  3520
#define NOTE_AS7 3729
#define NOTE_B7  3951
#define NOTE_C8  4186
#define NOTE_CS8 4435
#define NOTE_D8  4699
#define NOTE_DS8 4978

// Note durations [ms] (for 60 bpm):
#define WHOLE_NOTE               1000
#define HALF_NOTE                500
#define QUARTER_NOTE             250
#define EIGHTH_NOTE              125
#define SIXTEENTH_NOTE           63
#define THIRTY_SECOND_NOTE       31

#define GANZE_NOTE               1000
#define HALBE_NOTE               500
#define VIERTEL_NOTE             250
#define ACHTEL_NOTE              125
#define SECHZEHNTEL_NOTE         63
#define ZWEIUNDDREISSIGSTEL_NOTE 31

// Functions:
void Beep(int, int);
#define Piep(__tone, __duration) Beep(__tone, __duration)
#define noBeep() Beep(0, 0)
#define StopPiep() noBeep()
void Quack(void);
#define Quaak() Quack()

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// LEDs:
#define LED_R_GREEN_PIN 14
#define LED_L_RED_PIN   15

#define LED_EINGEBAUT   LED_BUILTIN
#define LED_R_GRUEN_PIN 14
#define LED_L_ROT_PIN   15

#define ALL_OFF         0
#define GREEN           1
#define RED             2
#define GREEN_RED       3
#define BUILTIN         4
#define GREEN_BUILTIN   5
#define RED_BUILTIN     6
#define ALL_ON          7

#define ALLE_AUS        0
#define GRUEN           1
#define ROT             2
#define GRUEN_ROT       3
#define EINGBAUT        4
#define GRUEN_EINGEBAUT 5
#define ROT_EINGEBAUT   6
#define ALLE_AN         7

#define ON  1
#define OFF 0

#define AN  1
#define AUS 0

// Functions:
void LEDs(int);
void LED1(int);
void LED2(int);
void LED3(int);

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/




/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

#endif

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Additional info
 ~ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Changelog:
 ~
 ~  ---> changes are documented in the file "RoboDuck.cpp"
 ~
 ~ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
