/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*------------------------- [c]2020 - D. Ottensmeyer ------------------------*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~
 ~ Target:    Arduino NANO with RoboDuck (created by the "Fakultät für Physik
 ~            der Universität Regensburg", Germany, in 2019).
 ~            Link: go.ur.de/roboduck
 ~ Example:   RoboDuck_Demo_01
 ~ Version:   0.85
 ~ Author(s): D. Ottensmeyer
 ~
 ~ Description:
 ~ In this example we show a first test for the RoboDuck.
 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Defines:
//#define SERVO_CENTER
//#define SERVO_DEFAULT
#define DEMO_RUN
// Demos (choose 1..3 of them!):
#define WALK
#define BEEPER_LEDS
#define ULTRASONIC

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Includes:
#include <RoboDuck.h>

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Constants:

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
// Variables:

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

void setup() {
/*
  // Initialize serial:
  Serial.begin(9600); 
  Serial.println("Arduino NANO RoboDuck Test 1!");
  Serial.println("");
  Serial.println("PLEASE ENSURE THAT ROBODUCK CAN MOVE FREELY!!!");
  Serial.println("");
*/

// Assign Arduino Nano ports to the LEDs:
  pinMode(LED_BUILTIN, OUTPUT);     // built-in LED pin
  pinMode(LED_R_GREEN_PIN, OUTPUT); // pin 14 (A0, PC0)
  pinMode(LED_L_RED_PIN, OUTPUT);   // pin 15 (A1, PC1)

// Assign an Arduino Nano port to the Beeper:
  pinMode(BEEPER_PIN, OUTPUT);      // pin 5 (PD5)

#ifdef SERVO_CENTER
  Servo_Init();
  AllServo_Center();
  while(1);
#endif

#ifdef SERVO_DEFAULT
  Servo_Init();  
  AllServo_Default();
  while(1);
#endif

#ifdef DEMO_RUN 
  Servo_Init();
  AllServo_Default();
  delay(2000);
#endif
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

void loop() {

#ifdef BEEPER_LEDS
// Test Beeper and LEDs:
  Quack();
  int z;
  z = 0;
  for (int a = 0; a < 25; a++) {
    LEDs(z);
    z++;
    if(z > 7) {
      z = 0;
      Quack(); // "Quack-quack" sound
    }
    delay(250);
  }
  Peep(NOTE_C4, QUARTER_NOTE);
  Peep(NOTE_G6, HALF_NOTE);
  Peep(NOTE_C4, EIGHTH_NOTE);
  Peep(NOTE_C4, EIGHTH_NOTE);
  delay(500);
#endif

#ifdef WALK
// Some simple walking moves:
  Walkahead(1, 30);
  delay(500);
  Walkback(1, 30);
  delay(500);
  Turnleft(1);
  delay(500);
  //Walkahead(5, 30);
  //delay(500);
  //Turnleft(2);
  //delay(500);
  //Walkahead(5, 30);
  //delay(500);
  Turnright(1);
  delay(500);
  /*Walkahead(5, 30);
  delay(500);
  Turnleft(3);
  delay(500);*/
  Serial.println("Dancing 1_2");
  Dancing1_2(); // /\ / / \ \ /\/\
  delay(500);
  Serial.println("Dancing 4");
  Dancing4(); // auf beiden Füßen so /\ stehen ...
  delay(500);
#endif

#ifdef BEEPER_LEDS
// Test Beeper and LEDs:
  Quack();
  //int z;
  z = 0;
  for (int a = 0; a < 25; a++) {
    LEDs(z);
    z++;
    if(z > 7) {
      z = 0;
      Quack(); // "Quack-quack" sound
    }
    delay(250);
  }
  Peep(NOTE_C4, QUARTER_NOTE);
  Peep(NOTE_G6, HALF_NOTE);
  Peep(NOTE_C4, EIGHTH_NOTE);
  Peep(NOTE_C4, EIGHTH_NOTE);
  delay(500);
#endif

#ifdef ULTRASONIC
// Test Ultrasonic Sensor:
  LEDs(ALL_OFF);
  while(1) {
    if (TooClose()) LEDs(RED); // Too close: red LED
    else LEDs(GREEN);          // Else:      green LED
    delay(50); 
  }
#endif

while(1);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
